/**
 * Anima: A singular journey
 * CS470 Capstone Project
 * Shawn Aldridge
 */


package anima;

import com.sun.opengl.util.Animator;
import com.sun.opengl.util.FPSAnimator;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.*;
import java.awt.*;
import javax.swing.JFrame;
import javax.swing.JComponent;
import java.awt.event.*;
import com.sun.opengl.util.GLUT;
import javax.media.opengl.GLCapabilities;





/**
 * Class to draw fullscreen background, also will likely hold score/stat info on sides of game screen
 */
public class LevelManager extends JFrame implements GLEventListener {

    GLCanvas canvas;
    JOptionPane option, error;
    JPanel ButtonPanel, CanvasPanel;
    JButton exit, selectProfile, deleteProfile, createProfile;
    Boolean level1, level2, cut;
    Level1 game;
    Level2 game2;
    CutScene1 cutScene;


    public LevelManager()
    {
        super("Anima: A singular journey");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLayout(new BorderLayout());
        canvas = new GLCanvas();
        ButtonPanel = new JPanel();
        ButtonPanel.setLayout(new GridLayout());


        GLCapabilities caps = new GLCapabilities();
        caps.setDoubleBuffered(true);
        caps.setHardwareAccelerated(true);

        level1 = false;
        level2 = false;
        cut = false;
        exit = new JButton("Admit Defeat");
        selectProfile = new JButton("Select Profile");
        deleteProfile = new JButton("Delete Profile");
        createProfile = new JButton("Create Profile");

        exit.addActionListener(new InnerHandler());



        

        //ButtonPanel.add(selectProfile);
        //ButtonPanel.add(deleteProfile);
        //ButtonPanel.add(createProfile);

        Dimension boxMin = new Dimension(20,20);
        Dimension boxPref = new Dimension(20,20);
        Dimension boxMax = new Dimension(20,20);
        ButtonPanel.add(new Box.Filler(boxMin, boxPref, boxMax));
        ButtonPanel.add(new Box.Filler(boxMin, boxPref, boxMax));
        ButtonPanel.add(exit);
        ButtonPanel.add(new Box.Filler(boxMin, boxPref, boxMax));
        ButtonPanel.add(new Box.Filler(boxMin, boxPref, boxMax));


        setUndecorated(true);
        setExtendedState(this.MAXIMIZED_BOTH);
        //setSize(800,600);


        ButtonPanel.setSize(800, 200);

        ButtonPanel.setBackground(Color.BLACK);
        add(ButtonPanel, BorderLayout.PAGE_END);
        //add(CanvasPanel, BorderLayout.PAGE_START);
        canvas.setFocusable(true);
        canvas.addMouseListener(new mouseHandler());


        add(canvas);


        final FPSAnimator animator = new FPSAnimator(canvas, 60);

        setLocationRelativeTo(null);
        setVisible(true);

       
        animator.start();

    }


    public void init(GLAutoDrawable drawable) {

        GL gl = drawable.getGL();
        GLU glu = new GLU();

        // Setup the drawing area and shading mode
        gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gl.glShadeModel(GL.GL_SMOOTH);
        gl.glEnable(GL.GL_DEPTH_TEST);

        gl.glMatrixMode(GL.GL_PROJECTION);
        gl.glLoadIdentity();
        gl.glOrtho(-50.0, 50.0, -50.0, 50.0, -50.0, 50.0);
        gl.glMatrixMode(GL.GL_MODELVIEW);

    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL gl = drawable.getGL();

        gl.glViewport(0, 0, width, height);

        gl.glMatrixMode(GL.GL_PROJECTION);
        gl.glLoadIdentity();
        //gl.glOrtho(-50.0, 50.0, -50.0, 50.0, -50.0, 50.0);
        gl.glOrtho(-(width/10), width/10, -(height/10), height/10, -50.0, 50.0);
        gl.glMatrixMode(GL.GL_MODELVIEW);
        gl.glLoadIdentity();


    }

    public void startScreen(GL gl, GLUT glut)
    {

        gl.glColor3f(0.3f, 0.3f, 1.0f);
        gl.glBegin(GL.GL_LINES);

        //first box
        gl.glVertex3f(-100, -50, 0);
        gl.glVertex3f(-100, 50, 0);

        gl.glVertex3f(-100, 50, 0);
        gl.glVertex3f(-40, 50, 0);

        gl.glVertex3f(-40, 50, 0);
        gl.glVertex3f(-40, -50, 0);

        gl.glVertex3f(-40, -50, 0);
        gl.glVertex3f(-100, -50, 0);
        //end first box

        //second box
        gl.glVertex3f(30, 0, 0);
        gl.glVertex3f(30, 50, 0);

        gl.glVertex3f(30, 50, 0);
        gl.glVertex3f(70, 50, 0);

        gl.glVertex3f(70, 50, 0);
        gl.glVertex3f(70, 0, 0);

        gl.glVertex3f(70, 0, 0);
        gl.glVertex3f(30, 0, 0);

        //Play stub button
        gl.glVertex3f(-30, 20, 0);
        gl.glVertex3f(-30, 40, 0);

        gl.glVertex3f(-30, 40, 0);
        gl.glVertex3f(20, 40, 0);

        gl.glVertex3f(20, 40, 0);
        gl.glVertex3f(20, 20, 0);

        gl.glVertex3f(20, 20, 0);
        gl.glVertex3f(-30, 20, 0);


        //Player's lounge stub button
        gl.glVertex3f(-30, -10, 0);
        gl.glVertex3f(-30, 10, 0);

        gl.glVertex3f(-30, 10, 0);
        gl.glVertex3f(20, 10, 0);

        gl.glVertex3f(20, 10, 0);
        gl.glVertex3f(20, -10, 0);

        gl.glVertex3f(20, -10, 0);
        gl.glVertex3f(-30, -10, 0);

        gl.glEnd();

        gl.glRasterPos3f(-100, 52, 0);
        glut.glutBitmapString(glut.BITMAP_HELVETICA_18, "Profiles");

        gl.glRasterPos3f(-99, 45, 0);
        glut.glutBitmapString(glut.BITMAP_HELVETICA_18, "Stub Profile");

        gl.glRasterPos3f(-99, 38, 0);
        glut.glutBitmapString(glut.BITMAP_HELVETICA_18, "Stub Profile 2");

        gl.glRasterPos3f(-99, 31, 0);
        glut.glutBitmapString(glut.BITMAP_HELVETICA_18, "Stub Profile 3");

        gl.glRasterPos3f(30, 52, 0);
        glut.glutBitmapString(glut.BITMAP_HELVETICA_18, "Difficulty Level");

        gl.glRasterPos3f(31, 45, 0);
        glut.glutBitmapString(glut.BITMAP_HELVETICA_18, "Easy");

        gl.glRasterPos3f(31, 38, 0);
        glut.glutBitmapString(glut.BITMAP_HELVETICA_18, "Medium");

        gl.glRasterPos3f(31, 31, 0);
        glut.glutBitmapString(glut.BITMAP_HELVETICA_18, "Hard");

        gl.glRasterPos3f(-30, 65, 0);
        glut.glutBitmapString(glut.BITMAP_TIMES_ROMAN_24, "Anima: A singular journey");

        gl.glRasterPos3f(-18, 29, 0);
        glut.glutBitmapString(glut.BITMAP_HELVETICA_18, "Start the journey");

        gl.glRasterPos3f(-18, -1, 0);
        glut.glutBitmapString(glut.BITMAP_HELVETICA_18, "Player's Lounge");

    }

    public void level1Background(GL gl, GLUT glut)
    {
        int k = -300;
        for(int j = -100; j < 100; j += 5)
        {
            for(int i = k; i < 200; i += 3)
            {
                gl.glRasterPos3f(i,j,0);
                glut.glutBitmapCharacter(glut.BITMAP_HELVETICA_18, '1');
                i += 3;
                gl.glRasterPos3f(i,j,0);
                glut.glutBitmapCharacter(glut.BITMAP_HELVETICA_18, '0');
            }
            double flip = Math.random();
            if(flip < 0.5) k += 3;
        }
        
    }


    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        GLUT glut = new GLUT();




        // Clear the drawing area
        gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);

        // Reset the current matrix to the "identity"
        gl.glLoadIdentity();


        if((!(level1)) && (!(level2))) startScreen(gl, glut);


        if(level1 || level2)
        {
            level1Background(gl, glut);
        }

        //if((game != null) && (game.lost) && (game.time + 2 < game.loseTime)) secondLevel();


        // Flush all drawing operations to the graphics card
        gl.glFlush();

    }//end method display

    public void firstLevel()
    {
        //game = new Level1();
        //game2 = new Level2();
        //game.canvas.addGLEventListener(game);
        //game2.canvas.addGLEventListener(game2);
        level1 = true;
        //level2 = true;
    }

    public void secondLevel()
    {
        //game = new Level1();
        //game2 = new Level2();
        //game.canvas.addGLEventListener(game);
        //game2.canvas.addGLEventListener(game2);
        //level1 = true;
        level2 = true;
    }

    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {}

    class InnerHandler implements ActionListener
    {

        public InnerHandler()
        {

        }

        public void actionPerformed(ActionEvent e)
        {
            if(e.getSource() == exit)
            {
                System.exit(1);
            }

        }

    }//end class InnerHandler

    class keyHandler implements KeyListener
    {
        public void keyReleased(KeyEvent e){}

        public void keyPressed(KeyEvent e)
        {

            if(e.getKeyCode() == e.VK_X)
            {

            }

        }

        public void keyTyped(KeyEvent e){}

    }//end class keyHandler

    class mouseHandler implements MouseListener
    {
        public void mousePressed(MouseEvent e)
        {

        }

        public void mouseReleased(MouseEvent e)
        {

        }

        public void mouseEntered(MouseEvent e) {

        }

        public void mouseExited(MouseEvent e) {

        }

        public void mouseClicked(MouseEvent e)
        {

            if(e.getButton() == e.BUTTON1)
            {


                if((e.getX() > 525) && (e.getX() < 785))
                {
                    if((e.getY() > 170) && (e.getY() < 275))
                    {
                        /*
                        game = new Level1();
                        //game2 = new Level2();
                        game.canvas.addGLEventListener(game);
                        //game2.canvas.addGLEventListener(game2);
                        level1 = true;
                        //level2 = true;
                         */
                        firstLevel();
                        //secondLevel();
                        //cut = true;
                    }
                }
            }





            if(e.getButton() == e.BUTTON3)
            {

            }

        }

    }//end inner class mouseHandler
}

